using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class CustomerOrdersBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            //
            //CustomerOrdersBO
            //'
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[co_pk],[co_cust_pk],[co_cc_pk],[co_TotalAmount],[co_TaxAmount],[co_GrandTotal],[co_CreatedAt],[co_CreatedBy],[co_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "co_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "CustomerOrders";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("co_pk", typeof(System.Int32)),
new DataColumn("co_cust_pk", typeof(System.Int32)),
new DataColumn("co_cc_pk", typeof(System.Int32)),
new DataColumn("co_TotalAmount", typeof(System.Decimal)),
new DataColumn("co_TaxAmount", typeof(System.Decimal)),
new DataColumn("co_GrandTotal", typeof(System.Decimal)),
new DataColumn("co_CreatedAt", typeof(System.DateTime)),
new DataColumn("co_CreatedBy", typeof(System.Int32)),
new DataColumn("co_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(CustomerOrdersBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(CustomerOrdersBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 co_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["co_pk"];
            }
            set
            {
                this.CurrentRow["co_pk"] = value;
            }
        }

        /// <summary>
        /// Customer Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 co_cust_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["co_cust_pk"];
            }
            set
            {
                this.CurrentRow["co_cust_pk"] = value;
            }
        }

        /// <summary>
        /// Credit card foreign key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Credit card foreign key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 co_cc_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["co_cc_pk"];
            }
            set
            {
                this.CurrentRow["co_cc_pk"] = value;
            }
        }

        /// <summary>
        /// Total amount before tax
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Total amount before tax"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal co_TotalAmount
        {
            get
            {
                return (System.Decimal)this.CurrentRow["co_TotalAmount"];
            }
            set
            {
                this.CurrentRow["co_TotalAmount"] = value;
            }
        }

        /// <summary>
        /// Tax amount
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Tax amount"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal co_TaxAmount
        {
            get
            {
                return (System.Decimal)this.CurrentRow["co_TaxAmount"];
            }
            set
            {
                this.CurrentRow["co_TaxAmount"] = value;
            }
        }

        /// <summary>
        /// Grand total (total + tax)
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Grand total (total + tax)"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal co_GrandTotal
        {
            get
            {
                return (System.Decimal)this.CurrentRow["co_GrandTotal"];
            }
            set
            {
                this.CurrentRow["co_GrandTotal"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime co_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["co_CreatedAt"];
            }
            set
            {
                this.CurrentRow["co_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// User Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("User Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 co_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["co_CreatedBy"];
            }
            set
            {
                this.CurrentRow["co_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 co_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["co_Version"];
            }
            set
            {
                this.CurrentRow["co_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum CustomerOrdersBOFieldNames
        {
            co_pk,
            co_cust_pk,
            co_cc_pk,
            co_TotalAmount,
            co_TaxAmount,
            co_GrandTotal,
            co_CreatedAt,
            co_CreatedBy,
            co_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CustomerOrdersBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<CustomerOrdersBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<CustomerOrdersBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<CustomerOrdersBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the CustomerOrdersBO class.
        /// </summary>
        static CustomerOrdersBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(14);
            _PropertyDescriptors.Add("co_pk", new FieldDescriptor(CustomerOrdersBOFieldNames.co_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("co_cust_pk", new FieldDescriptor(CustomerOrdersBOFieldNames.co_cust_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("co_cc_pk", new FieldDescriptor(CustomerOrdersBOFieldNames.co_cc_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("co_TotalAmount", new FieldDescriptor(CustomerOrdersBOFieldNames.co_TotalAmount, typeof(System.Decimal)));
            _PropertyDescriptors.Add("co_TaxAmount", new FieldDescriptor(CustomerOrdersBOFieldNames.co_TaxAmount, typeof(System.Decimal)));
            _PropertyDescriptors.Add("co_GrandTotal", new FieldDescriptor(CustomerOrdersBOFieldNames.co_GrandTotal, typeof(System.Decimal)));
            _PropertyDescriptors.Add("co_CreatedAt", new FieldDescriptor(CustomerOrdersBOFieldNames.co_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("co_CreatedBy", new FieldDescriptor(CustomerOrdersBOFieldNames.co_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("co_Version", new FieldDescriptor(CustomerOrdersBOFieldNames.co_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(9);
            _AllFieldsList.Add("co_pk");
            _AllFieldsList.Add("co_cust_pk");
            _AllFieldsList.Add("co_cc_pk");
            _AllFieldsList.Add("co_TotalAmount");
            _AllFieldsList.Add("co_TaxAmount");
            _AllFieldsList.Add("co_GrandTotal");
            _AllFieldsList.Add("co_CreatedAt");
            _AllFieldsList.Add("co_CreatedBy");
            _AllFieldsList.Add("co_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(9);
            _FieldDbTypes.Add("co_pk", DbType.Int32);
            _FieldDbTypes.Add("co_cust_pk", DbType.Int32);
            _FieldDbTypes.Add("co_cc_pk", DbType.Int32);
            _FieldDbTypes.Add("co_TotalAmount", DbType.Currency);
            _FieldDbTypes.Add("co_TaxAmount", DbType.Currency);
            _FieldDbTypes.Add("co_GrandTotal", DbType.Currency);
            _FieldDbTypes.Add("co_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("co_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("co_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(10);
            _FieldEnums.Add("co_pk", CustomerOrdersBOFieldNames.co_pk);
            _FieldEnums.Add("co_cust_pk", CustomerOrdersBOFieldNames.co_cust_pk);
            _FieldEnums.Add("co_cc_pk", CustomerOrdersBOFieldNames.co_cc_pk);
            _FieldEnums.Add("co_TotalAmount", CustomerOrdersBOFieldNames.co_TotalAmount);
            _FieldEnums.Add("co_TaxAmount", CustomerOrdersBOFieldNames.co_TaxAmount);
            _FieldEnums.Add("co_GrandTotal", CustomerOrdersBOFieldNames.co_GrandTotal);
            _FieldEnums.Add("co_CreatedAt", CustomerOrdersBOFieldNames.co_CreatedAt);
            _FieldEnums.Add("co_CreatedBy", CustomerOrdersBOFieldNames.co_CreatedBy);
            _FieldEnums.Add("co_Version", CustomerOrdersBOFieldNames.co_Version);
            _FieldEnums.Add("CUSTOM_FIELD", CustomerOrdersBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(9);
            _FieldLengths.Add("co_pk", 4);
            _FieldLengths.Add("co_cust_pk", 4);
            _FieldLengths.Add("co_cc_pk", 4);
            _FieldLengths.Add("co_TotalAmount", 8);
            _FieldLengths.Add("co_TaxAmount", 8);
            _FieldLengths.Add("co_GrandTotal", 8);
            _FieldLengths.Add("co_CreatedAt", 8);
            _FieldLengths.Add("co_CreatedBy", 4);
            _FieldLengths.Add("co_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(9);
            _FieldNativeDbTypes.Add("co_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("co_cust_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("co_cc_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("co_TotalAmount", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("co_TaxAmount", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("co_GrandTotal", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("co_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("co_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("co_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(9);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the CustomerOrdersBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<CustomerOrdersBOFieldNames>
        {
            public FieldDescriptor(CustomerOrdersBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(CustomerOrdersBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case CustomerOrdersBOFieldNames.co_pk:
                        return ((CustomerOrdersBO)component).co_pk;
                    case CustomerOrdersBOFieldNames.co_cust_pk:
                        return ((CustomerOrdersBO)component).co_cust_pk;
                    case CustomerOrdersBOFieldNames.co_cc_pk:
                        return ((CustomerOrdersBO)component).co_cc_pk;
                    case CustomerOrdersBOFieldNames.co_TotalAmount:
                        return ((CustomerOrdersBO)component).co_TotalAmount;
                    case CustomerOrdersBOFieldNames.co_TaxAmount:
                        return ((CustomerOrdersBO)component).co_TaxAmount;
                    case CustomerOrdersBOFieldNames.co_GrandTotal:
                        return ((CustomerOrdersBO)component).co_GrandTotal;
                    case CustomerOrdersBOFieldNames.co_CreatedAt:
                        return ((CustomerOrdersBO)component).co_CreatedAt;
                    case CustomerOrdersBOFieldNames.co_CreatedBy:
                        return ((CustomerOrdersBO)component).co_CreatedBy;
                    case CustomerOrdersBOFieldNames.co_Version:
                        return ((CustomerOrdersBO)component).co_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case CustomerOrdersBOFieldNames.co_pk:
                        ((CustomerOrdersBO)component).co_pk = (System.Int32)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_cust_pk:
                        ((CustomerOrdersBO)component).co_cust_pk = (System.Int32)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_cc_pk:
                        ((CustomerOrdersBO)component).co_cc_pk = (System.Int32)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_TotalAmount:
                        ((CustomerOrdersBO)component).co_TotalAmount = (System.Decimal)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_TaxAmount:
                        ((CustomerOrdersBO)component).co_TaxAmount = (System.Decimal)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_GrandTotal:
                        ((CustomerOrdersBO)component).co_GrandTotal = (System.Decimal)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_CreatedAt:
                        ((CustomerOrdersBO)component).co_CreatedAt = (System.DateTime)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_CreatedBy:
                        ((CustomerOrdersBO)component).co_CreatedBy = (System.Int32)value;
                        break;
                    case CustomerOrdersBOFieldNames.co_Version:
                        ((CustomerOrdersBO)component).co_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
